
////////////////////////////////////////////////////////////
//	File:		"Animation.h"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 17, 2008
//	Purpose:	Contains all the frames for a given animation.
////////////////////////////////////////////////////////////

#ifndef ANIMATION_H_
#define ANIMATION_H_

#include "Frame.h"

#include <vector>
using std::vector;

class CAnimation
{

public:

	/* Public Data Members */

protected:

	/* Protected Data Members */

private:

	/* Private Data Members */
	string				m_szAnimationName;		// name of the current animation
	vector<CFrame*>		m_vFrameList;			// list of frames for this animation
	bool				m_bIsLooping;			// determines if animation is looping

	/* Disabled Functions */

public:

	////////////////////////////////////////////////////////////
	//	Function:	Constructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Initializes the object.
	////////////////////////////////////////////////////////////
	CAnimation();
	CAnimation(string szAnimationName);

	////////////////////////////////////////////////////////////
	//	Function:	Accessors
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Gets the specified type.
	////////////////////////////////////////////////////////////
	inline string GetAnimationName(void)	{ return m_szAnimationName; }
	inline int GetFrameCount(void)			{ return (int)m_vFrameList.size(); }
	inline bool GetIsLooping(void)			{ return m_bIsLooping; }

	////////////////////////////////////////////////////////////
	//	Function:	Mutators
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Sets the specified type.
	////////////////////////////////////////////////////////////
	inline void SetIsLooping(bool bIsLooping)	{ m_bIsLooping = bIsLooping; }

	////////////////////////////////////////////////////////////
	//	Function:	Destructor
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Deallocates the object.
	////////////////////////////////////////////////////////////
	~CAnimation();

	////////////////////////////////////////////////////////////
	//	Function:	AddFrame
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Adds the frame to the animation frame list.
	////////////////////////////////////////////////////////////
	inline void AddFrame(CFrame *pFrame)
		{ m_vFrameList.push_back(pFrame); }

	////////////////////////////////////////////////////////////
	//	Function:	GetFrame
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Returns the given frame in an animation.
	////////////////////////////////////////////////////////////
	inline CFrame* GetFrame(int nFrame)
		{ return m_vFrameList[nFrame]; }

	////////////////////////////////////////////////////////////
	//	Function:	Clear
	//	Modified:	[JW] November 17, 2008
	//	Purpose:	Removes all the frames.
	////////////////////////////////////////////////////////////
	void Clear();

protected:

	/* Protected Functions */

private:

	/* Private Functions */

};

#endif
